% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roi_to_gams.R
\name{to_gams}
\alias{to_gams}
\title{Translate to GAMS}
\usage{
to_gams(x)
}
\arguments{
\item{x}{an \pkg{ROI} object of class \code{OP}.}
}
\value{
a character string giving the GAMS optimization model.
}
\description{
Translate a \code{ROI} \code{OP} to \code{GAMS} code.
This function can translate optimization problems with linear or quadratic objective
and linear or quadratic constraints.
}
\examples{
library("ROI")
mat <- matrix(c(3, 4, 2, 2, 1, 2, 1, 3, 2), nrow=3, byrow=TRUE)
x <- OP(objective = c(2, 4, 3),
        constraints = L_constraint(L = mat,
                                   dir = c("<=", "<=", "<="),
                                   rhs = c(60, 40, 80)),
        bounds = V_bound(ui = seq_len(3), ub = c(1000, Inf, 1000), nobj = 3),
        maximum = TRUE)
writeLines(to_gams(x))
}
