% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_omdb_items.R
\name{search_omdb_items}
\alias{search_omdb_items}
\title{Search OMDB Items}
\usage{
search_omdb_items(movie, type = "movie", year = NULL, page = 1,
  include_gif = TRUE, API_KEY = Sys.getenv("API_KEY"))
}
\arguments{
\item{movie}{String of movie/series name}

\item{type}{Default: 'movie'. Valid options are 'movie' or 'series'.}

\item{year}{Optional. Year of release.}

\item{page}{The number of results returned. 1: 10 results, 2: 20 results...}

\item{include_gif}{If TRUE, the result includes a gif of the movies/series. Default: TRUE.}

\item{API_KEY}{OMBD Api Key. Default: Get the Api Key from system environment. Use Sys.setenv('API_KEY' = 'XXXXX'). More information in: http://www.omdbapi.com/apikey.aspx}
}
\value{
If include_gif is TRUE, returns a list with a tibble with the movie information and a gif of the films. If include_image is FALSE, only returns the tibble.
}
\description{
This function searches OMDB Api Items (movies or series) by name, type and year.
}
\examples{
\dontrun{
search_omdb_items('Titanic')
}
}
\author{
Alberto Almuiña
}
