% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROlogit.R
\docType{data}
\name{inpat_bg}
\alias{inpat_bg}
\title{Inpatient blood glucose data for 2487 patients}
\format{
A data frame with 2487 rows and 13 variables:
\describe{
  \item{bg_mean}{Mean BG readings within each episode, in mmol/L.}
  \item{bg_sd}{Standard deviation of BG readings within each episode.}
  \item{sex}{Gender of patients.}
  \item{ward}{Whether each patient is in the medical ward (\code{ward = 0})
    or surgical ward (\code{ward = 1}).}
  \item{age_group}{Patient group defined based on the median age.}
  \item{los_group}{Patient group defined based on the median of duration of
    monitoring episode.}
  \item{bg_freq_group}{Patient group defined based on the median of daily
    BG monitoring frequency.}
  \item{age}{Patients' age.}
  \item{los}{Patients' duration of monitoring episode.}
  \item{bg_freq}{Patients' daily BG monitoring frequency.}
}
}
\usage{
inpat_bg
}
\description{
A simulated dataset containing inpatient point-of-care blood
  glucose (BG) measurements from 2487 non-critical care adult patients above
  40 years old. Data was simulated based on real data.
}
\references{
Tan CS, Støer NC, Chen Y, Andersson M, Ning Y, Wee HL, Khoo EY,
 Tai ES, Kao SL, Reilly M. A stratification approach using logit-based models
 for confounder adjustment in the study of continuous outcomes. Statistical
 methods in medical research. 2017 Jan 1:0962280217747309.
}
\keyword{datasets}
