% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Optimus.R
\name{Optimus}
\alias{Optimus}
\title{Acceptance Ratio Simulated Annealing and Acceptance Ratio Replica Exchange Monte Carlo Optimisation Engine}
\usage{
Optimus(
  NUMITER = 1e+06,
  STATWINDOW = 70,
  T.INI = 1e-05,
  T.ADJSTEP = 5e-09,
  TSCLnum = 2,
  T.SCALING = 3,
  T.MIN = 5e-09,
  T.DELTA = 2,
  DUMP.FREQ = 10000,
  LIVEPLOT = TRUE,
  LIVEPLOT.FREQ = 1e+05,
  PDFheight = 29,
  PDFwidth = 20,
  NCPU = 4,
  LONG = TRUE,
  SEED = 840,
  OPTNAME = "",
  DATA = NULL,
  K.INITIAL = 0,
  rDEF,
  mDEF,
  uDEF,
  EXCHANGE.FREQ = 1000,
  ACCRATIO = c(90, 50, 5, 1),
  CYCLES = 10,
  ACCRATIO.IN = 90,
  ACCRATIO.FIN = 0.5,
  OPT.TYPE = "SA",
  DIR,
  starcore = NULL
)
}
\arguments{
\item{NUMITER}{Number of model optimisation steps.}

\item{STATWINDOW}{Number of last ongoing iterations to calculate
acceptance ratio for temperature auto-adjustment.}

\item{T.INI}{Initial temperature (K) for Metropolis criterion.}

\item{T.ADJSTEP}{Temperature change step-size for temperature
auto-adjustment based on the actual acceptance ratio.}

\item{TSCLnum}{Cutoff for one of the NumofAccRatSMIdeal and
NumofAccRatGRIdeal numbers after which the adjustment
step is multiplied by T.SCALING.}

\item{T.SCALING}{See above.}

\item{T.MIN}{Value to which the pseudo-temperature is set when the}

\item{T.DELTA}{Minimum value by which acceptance ratio in a STATWINDOW
must differ from the ideal acceptance ratio for the
temperature control unit to make a temperature
adjustment.}

\item{DUMP.FREQ}{The frequency (in steps) of writing the found ongoing
best model.}

\item{LIVEPLOT}{Plotting the optimisation process in a pdf file.}

\item{LIVEPLOT.FREQ}{Frequency (in steps) of plotting the results.}

\item{PDFheight}{Plot height in inches.}

\item{PDFwidth}{Plot width in inches.}

\item{NCPU}{Number of CPU cores to use, by running more replicas
of the optimisation. The usage of more than 1 cores
will attempt to load the foreach and doParallel
libraries in the case of SA Optimus}

\item{LONG}{If TRUE, it means that a long simulation is expected to
be done, hence the memory-friendly mode will be
activated.}

\item{SEED}{Setting the seed for the random number generator.}

\item{OPTNAME}{The name of the optimisation process.}

\item{DATA}{A list that holds any supplementary data that
functions mDEF or uDEF need to access.}

\item{K.INITIAL}{The initial parameter configuration from which the
optimisation process will begin.}

\item{rDEF}{Function that defines a rule by which the
parameters(K) are randomly altered.}

\item{mDEF}{Model function that operates on the parameters to be
optimized (K) and returns an observable object O.}

\item{uDEF}{Function that evaluates the performance of a given set
of parameters K.}

\item{EXCHANGE.FREQ}{Frequency of exchanges (NUMITER should be divisible by
this number, for RE Optimus).}

\item{ACCRATIO}{Vector of Acceptance Ratios for each replica (length of
ACCRATIO must be equal to NCPU, for RE Optimus).}

\item{CYCLES}{Number of annealing cycles (NUMITER should be divisible
by this number, for SA Optimus).}

\item{ACCRATIO.IN}{Initial acceptance ratio (\%) at the beginning of each
constituent annealing cycles (for SA Optimus).}

\item{ACCRATIO.FIN}{Final acceptance ratio (\%) at the end of each
constituent annealing cycles (for SA Optimus).}

\item{OPT.TYPE}{String specifying which optimisation protocol to use.
Enter "SA" for Simulated Annealing or "RE" for Replica
Exchange (default value is "SA")}

\item{DIR}{String specifying which optimisation protocol to use.}

\item{starcore}{Experimental variable of type list, holding some
parameters for in-lab starcore use only.}
}
\value{
A probabilistic optimal parameter configuration K.
}
\description{
Acceptance Ratio Simulated Annealing and Acceptance Ratio Replica Exchange Monte Carlo Optimisation Engine
}
\examples{

K <- IJ_ORIG
K$j <- sample(x=K$j, size=nrow(K), replace=FALSE)
out.dir <- tempdir()

Optimus(NCPU=1, OPTNAME="IJ.NEW.OPTI.SA", NUMITER=500, CYCLES=2, DIR=out.dir,
        DUMP.FREQ=10, LONG=FALSE, OPT.TYPE="SA", K.INITIAL=K,
        rDEF=ex.r.fun, mDEF=ex.m.fun, uDEF=ex.u.fun,
        DATA=list(IJ_ORIG=IJ_ORIG, gaplimit=50, numContacts=nrow(IJ_ORIG)))
}
