% $Id: rs98-RPPASPACESettings-class.Rd

\name{RPPASPACESettings-class}
\alias{RPPASPACESettings-class}
\alias{RPPASPACESettings}
\alias{paramString,RPPASPACESettings-method}
\alias{write.summary,RPPASPACESettings-method}
\alias{fitCurveAndSummarizeFromSettings}
\alias{is.RPPASPACESettings}
\docType{class}
\title{Class \dQuote{RPPASPACESettings}}
\description{
  The RPPASPACESettings class represents the arguments needed
  to perform curve fitting.
}
\usage{
RPPASPACESettings(txtdir,
				imgdir,
				outdir,
				designparams,
				fitparams,
				spatialparams=NULL,
				normparams,
				doprefitqc=FALSE,
				onlynormqcgood=doprefitqc,
				parallelClusterSize=as.integer(1),
				createcombinedoutputimage = FALSE,
				imageextension=".tif", 
				imagerotation=as.integer(0),
				residualsrotation=as.integer(0),
				warningsFileName="warnings.txt",
				errorsFileName = "errors.txt"
)
fitCurveAndSummarizeFromSettings(settings)
is.RPPASPACESettings(x)
\S4method{write.summary}{RPPASPACESettings}(object,
              path=as(object@outdir, "character"),
              \dots)
\S4method{paramString}{RPPASPACESettings}(object,
            designparams.slots,
            fitparams.slots,
            spatialparams.slots,
            normparams.slots,
            \dots)
}
\arguments{
  \item{txtdir}{character string specifying the directory containing
    quantification files in text format}
  \item{imgdir}{character string specifying the directory containing
    image files associated with each of the aforementioned quantification 
    files, or \code{NULL}. All image files for a given run must be of one 
    image file type. Other files in the directory will be ignored.}
  \item{outdir}{character string specifying the directory where output
    from analysis should be stored. Must be writable.}
  \item{designparams}{object of class \code{RPPADesignParams}}
  \item{fitparams}{object of class \code{RPPAFitParams}}
  \item{spatialparams}{object of class \code{RPPASpatialParams}, or \code{NULL}}
  \item{normparams}{object of class \code{RPPANormalizationParams}}
  \item{doprefitqc}{logical scalar. If \code{TRUE}, performs pre-fit quality control.}
  \item{onlynormqcgood}{logical scalar. If \code{TRUE}, filters the slides
    to be normalized according to their pre-fit quality control scores.}
  \item{parallelClusterSize}{Number of parallel cpus to use on computer
    when running RPPASPACE. Spatial corrections and fitting diltion series to
    the calculated curve sections of the code will be done in parallel 
    when this number is greater than 1.
    Defaults to 1 for backwards compatibility if not specified.}
  \item{createcombinedoutputimage}{logical scalar. If \code{TRUE}, an output png file will 
    be created for each valid slide in the set. The png file  that is a composite 
    of the two generated png files and the original slide image.}
  \item{imageextension}{character string specifying extension to use when searching
    for images matching the slide file names. Acceptable values are 
    (".tif", ".png", ".bmp", ".gif", ".jpg")}
  \item{imagerotation}{numeric scalar containing 90 degree value to rotate the 
    input image by when appending it below the generated graphs in the combined output 
    image file for each slide. Defaults to 0 if not specified.  
    Acceptable values (0, 90, 180, 270)}
  \item{residualsrotation}{numeric scalar containing 90 degree value to rotate 
    the generated residuals image by when generating the output graphic.  
    This should be used if the layout of the information in the input txt file 
    does not match the orientation of the slide	input image. Defaults to 0 if
    not specified.  Acceptable values (0, 90, 180, 270)}
  \item{warningsFileName}{character string specifying file to append any warnings 
    generated by this function. Defaults to "warnings.txt"}
  \item{errorsFileName}{character string specifying file to append any errors 
    generated by this function. Defaults to "errors.txt"}
  \item{object}{object of class \code{RPPASPACESettings}}
  \item{settings}{object of class \code{RPPASPACESettings}}
  \item{x}{object of class \code{RPPASPACESettings}}
  \item{path}{character string specifying the directory where settings
    summary should be saved. Must be writable.}
  \item{designparams.slots}{strings specifying \code{RPPADesignParams}
    slotnames to display (for debugging)}
  \item{fitparams.slots}{strings specifying \code{RPPAFitParams}
    slotnames to display (for debugging)}
  \item{spatialparams.slots}{strings specifying \code{RPPASpatialParams}
    slotnames to display (for debugging)}
  \item{normparams.slots}{strings specifying \code{RPPANormalizationParams}
    slotnames to display (for debugging)}
  \item{\dots}{extra arguments for generic routines}
}
\section{Objects from the Class}{
  Although objects of the class can be created by a direct call to
  \link[methods]{new}, the preferred method is to use the
  \code{RPPASPACESettings} generator function.
}
\section{Slots}{
  \describe{
    \item{\code{txtdir}:}{object of class \code{Directory} specifying the
      directory containing quantification files in text format}
    \item{\code{imgdir}:}{object of class \code{Directory} specifying the
      directory containing \acronym{TIFF} image files}
    \item{\code{outdir}:}{object of class \code{Directory} specifying the
      directory where analysis results should be stored}
    \item{\code{designparams}:}{object of class \code{RPPADesignParams}
      specifying the parameters that describe how a particular set of
      \acronym{RPPA} slides was designed}
    \item{\code{fitparams}:}{object of class \code{RPPAFitParams}
      specifying the parameters that control model fit}
    \item{\code{spatialparams}:}{object of class \code{RPPASpatialParams}
      specifying the parameters that control spatial adjustment}
    \item{\code{normparams}:}{object of class \code{RPPANormalizationParams}
      specifying the parameters that control normalization}
    \item{\code{doprefitqc}:}{see argument}
    \item{\code{createcombinedoutputimage}:}{see argument}
    \item{\code{imageextension}:}{see argument}
    \item{\code{imagerotation}:}{see argument}
    \item{\code{residualsrotation}:}{see argument}    
    \item{\code{onlynormqcgood}:}{see argument}
    \item{\code{seriesToIgnore}:}{see argument}
    \item{\code{parallelClusterSize}:}{see argument}
    \item{\code{warningsFileName}:}{see argument}
    \item{\code{errorsFileName}:}{see argument}
  }
}
\section{Methods}{
  \describe{
    \item{paramString}{
      \code{signature(object = "RPPASPACESettings")}:\cr
      Returns string representation of object.}
    \item{write.summary}{
      \code{signature(object = "RPPASPACESettings")}:\cr
      Writes a text file representation of object.}
  }
}
\value{
  The \code{RPPASPACESettings} generator returns an object of class
  \code{RPPASPACESettings}.

  The \code{is.RPPASPACESettings} method returns \code{TRUE} if its
  argument is an object of class \code{RPPASPACESettings}.

  The \code{paramString} method returns a character vector, possibly
  empty but never \code{NULL}.

  The \code{write.summary} method invisibly returns \code{NULL}.
}
\section{Warning}{
  The \code{paramString} method should not be called by user except for
  informational purposes. The content and format of the returned string
  may vary between different versions of this package.
}
\author{
  P. Roebuck \email{paul_roebuck@comcast.net},
  James M. Melott \email{jmmelott@mdanderson.org}
}
\seealso{
  \code{\linkS4class{Directory}},
  \code{\linkS4class{RPPADesignParams}},
  \code{\linkS4class{RPPASpatialParams}},
  \code{\linkS4class{RPPAFitParams}},
  \code{\linkS4class{RPPANormalizationParams}}
}
\examples{
    \dontrun{
showClass("RPPASPACESettings")

#Insert an existing directory containing txt, img, and out subdirectories
#
analysishome <- "C:/temp"  

txtdir <- file.path(analysishome, "txt" )
imgdir <- file.path(analysishome, "img" )
outdir <- file.path(analysishome, "out")
number_cpus_to_use <- 2

warningsFileName <- "warnings.txt"
errorsFileName <- "errors.txt"

designparams <- RPPADesignParams(center=FALSE,
							seriesToIgnore=list(),
							majorXDivisions=as.integer(10),
							majorYDivisions=as.integer(10)
							)

spatialparams <- RPPASpatialParams(cutoff=0.8,
							k=100,
							gamma=0.1,
							plotSurface=FALSE)

fitparams <- RPPAFitParams(measure="Net.Value",
							method="nls",
							model="cobs",
							trim=2,
							ci=FALSE,
							ignoreNegative=FALSE,
							warnLevel=-1
							)

normparams <- RPPANormalizationParams(method="none")

settings <- RPPASPACESettings(txtdir=txtdir,
				imgdir=imgdir,
				outdir=outdir,
				designparams=designparams,
				spatialparams=spatialparams,
				doprefitqc=TRUE,
				fitparams=fitparams,
				normparams=normparams,
				onlynormqcgood=FALSE,
				imageextension=".jpg",
				createcombinedoutputimage=TRUE,
				warningsFileName=warningsFileName,
				parallelClusterSize=as.integer(number_cpus_to_use))

#Print the created object
paramString(settings)
	}
}

\keyword{classes}
\keyword{file}

