% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpygeo_reticulate.R
\name{rpygeo_save}
\alias{rpygeo_save}
\title{Save temporary raster to workspace}
\usage{
rpygeo_save(data, filename)
}
\arguments{
\item{data}{\code{reticulate} object or full path of the ArcPy function output}

\item{filename}{Filename with extension or without extension if the workspace is file geodatabase}
}
\description{
This function saves temporary a raster as permanent raster to the workspace.
}
\details{
Some ArcPy functions have no parameter to specify an output raster. Instead they return a raster object and a temporary raster is saved to the scratch workspace. This functions writes the temporary raster as a permanent raster to the workspace.

How the file is written depends on the workspace and scratch workspace environment settings.

\itemize{
  \item Workspace and scratch workspace are directories: Raster is loaded with the \code{raster} package and is written to workspace directory. The file format is inferred from the file extension in the \code{filename} parameter.
  \item Workspace and scratch workspace are file geodatabases: Raster is copied to workspace file geodatabase. No file extension necessary for the \code{filename} parameter.
  \item Workspace is file geodatabase and scratch workspace is directory: Raster is copied to workspace file geodatabase. No file extension necessary for the \code{filename} parameter.
  \item Workspace is directory and scratch workspace is file geodatabase: Raster is exported to workspace directory. The \code{filename} parameter is ignored due to restrictions in \code{arcpy.RasterToOtherFormat_conversion} function. If the automatically generated filename already exists, a number is appended to the end of the filename.
}
}
\examples{

\dontrun{
# Load packages
library(RPyGeo)
library(RQGIS)
library(magrittr)

# Get data
data(dem, package = "RQGIS")

# Load the ArcPy module and build environment
arcpy <- arcpy_build_env(overwrite = TRUE, workspace = tempdir())

# Write raster to workspace directory
writeRaster(dem, file.path(tempdir(), "dem.tif"), format = "GTiff")

# Calculate temporary aspect file and save to workspace
arcpy$sa$Aspect(in_raster = "dem.tif") \%>\%
  rpygeo_save("aspect.tif")
}

}
\author{
Marc Becker
}
