% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_rb2stage.R
\name{n.rb.2stage.1}
\alias{n.rb.2stage.1}
\title{sample size for 2-stage risk-based surveillance, risk factor at cluster level only}
\usage{
n.rb.2stage.1(rr, ppr, spr, pstar.c, pstar.u, se = 1, sep.c = 0.95,
  sep.sys = 0.95)
}
\arguments{
\item{rr}{relative risk values (vector of values, corresponding 
to the number of risk strata)}

\item{ppr}{population proportions corresponding to 
rr values (vector of equal length to rr)}

\item{spr}{planned surveillance proportions corresponding to 
rr values - the proportions of the total sample to be collected 
from each risk stratum (vector of equal length to rr).}

\item{pstar.c}{cluster (herd) level design prevalence, scalar,
either proportion or integer}

\item{pstar.u}{unit (animal) level design prevalence, scalar,
either proportion or integer}

\item{se}{unit sensitivity of test (proportion), scalar, default = 1}

\item{sep.c}{desired cluster-level sensitivity (proportion), scalar, default = 0.95}

\item{sep.sys}{desired population-level sensitivity (proportion), scalar, default = 0.95}
}
\value{
A list of seven elements: 1) a vector (of the same length as rr) of the 
numbers of clusters to sample from each risk stratum, 2) the total number of clusters
to be sampled, 3) a vector of EPI values for each risk stratum, 
4) a vector of adjusted risk values for each risk stratum,
5) the number of untis to be sampled per cluster
6) a vector of the total numbers of units to be sampled for each risk stratum
7) the overall total number of units to be sampled
}
\description{
Calculates sample size required (clusters and units)
for a 2-stage risk-based survey with a single risk factor at the 
cluster level only.
}
\examples{
rr<- c(5,3,1)
ppr<- c(0.1, 0.2, 0.7)
spr<- c(0.4, 0.4, 0.2)
n.rb.2stage.1(rr, ppr, spr, pstar.c=0.01, pstar.u=0.1, se =0.9, sep.c=0.8, sep.sys=0.95) 
n.rb.2stage.1(c(3,1), c(0.2,0.8), c(0.7,0.3),0.05, 0.1, 0.9, 0.95, 0.99)
}
\keyword{methods}
