% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freedom_functions_1.R
\name{pfree.1}
\alias{pfree.1}
\title{Probability of freedom for single time period}
\usage{
pfree.1(sep, p.intro, prior = 0.5)
}
\arguments{
\item{sep}{population sensitivity for time period (scalar or
vector)}

\item{p.intro}{probability of introduction for time period (scalar
or vector of same length as sep)}

\item{prior}{prior probability of freedom before surveillance (scalar
or vector of same length as sep)}
}
\value{
\code{data.frame} with columns for sep, p.intro, discounted
prior, pfree, pfree.equ and prior.equ
}
\description{
Calculates the posterior probability (confidence) of disease
  freedom (negative predictive value) for a single time period
}
\examples{
# examples for pfree.1
pfree.1(0.8, 0.01, 0.5)
pfree.1(0.6, c(0.001, 0.005, 0.01, 0.02, 0.05), 0.5)
pfree.1(runif(10, 0.4, 0.6), 0.01, 0.5)
pfree.1(runif(10, 0.4, 0.6), runif(10, 0.005, 0.015), 0.5)
}
\keyword{methods}
