% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-random-multinom-walk.R
\name{random_multinomial_walk}
\alias{random_multinomial_walk}
\title{Generate Multiple Random Multinomial Walks}
\usage{
random_multinomial_walk(
  .num_walks = 25,
  .n = 100,
  .size = 3,
  .prob = rep(1/3, .n),
  .initial_value = 0,
  .samp = TRUE,
  .replace = TRUE,
  .sample_size = 0.8,
  .dimensions = 1
)
}
\arguments{
\item{.num_walks}{Integer. Number of random walks to generate. Default is 25.}

\item{.n}{Integer. Length of each walk (number of steps). Default is 100.}

\item{.size}{Integer. Number of trials for each multinomial draw. Default is 3.}

\item{.prob}{Numeric vector. Probabilities for each outcome. Default is rep(1/3, .n).}

\item{.initial_value}{Numeric. Starting value of the walk. Default is 0.}

\item{.samp}{Logical. Whether to sample the steps. Default is TRUE.}

\item{.replace}{Logical. Whether sampling is with replacement. Default is TRUE.}

\item{.sample_size}{Numeric. Proportion of steps to sample (0-1). Default is 0.8.}

\item{.dimensions}{Integer. Number of dimensions (1, 2, or 3). Default is 1.}
}
\value{
A tibble containing the generated random walks with columns:
\itemize{
\item \code{walk_number}: Factor representing the walk number.
\item \code{step_number}: Step index.
\item \code{value}: Value of the walk at each step.
\item Cumulative statistics: cum_sum, cum_prod, cum_min, cum_max, cum_mean.
}

The following are also returned based upon how many dimensions there are and could be any of x, y and or z:
\itemize{
\item \code{cum_sum}: Cumulative sum of \code{dplyr::all_of(.dimensions)}.
\item \code{cum_prod}: Cumulative product of \code{dplyr::all_of(.dimensions)}.
\item \code{cum_min}: Cumulative minimum of \code{dplyr::all_of(.dimensions)}.
\item \code{cum_max}: Cumulative maximum of \code{dplyr::all_of(.dimensions)}.
\item \code{cum_mean}: Cumulative mean of \code{dplyr::all_of(.dimensions)}.
}
}
\description{
A multinomial random walk is a stochastic process in which each step is drawn
from the multinomial distribution. This function allows for the simulation of
multiple independent random walks in one, two, or three dimensions, with user
control over the number of walks, steps, trials, probabilities, and dimensions.
Sampling options allow for further customization, including the ability to
sample a proportion of steps and to sample with or without replacement. The
resulting data frame includes cumulative statistics for each walk.
}
\details{
The \code{random_multinomial_walk} function generates multiple random walks using
the multinomial distribution via \code{stats::rmultinom()}. Each walk is a sequence
of steps where each step is a random draw from the multinomial distribution.
The user can specify the number of walks, steps, trials per step, and the
probability vector. Sampling options allow for further customization,
including the ability to sample a proportion of steps and to sample with or
without replacement. The resulting data frame includes cumulative statistics
for each walk, making it suitable for simulation studies and visualization.
}
\examples{
set.seed(123)
random_multinomial_walk()

set.seed(123)
random_multinomial_walk(.dimensions = 3) |>
  head() |>
  t()

}
\seealso{
Other Generator Functions: 
\code{\link{brownian_motion}()},
\code{\link{discrete_walk}()},
\code{\link{geometric_brownian_motion}()},
\code{\link{random_beta_walk}()},
\code{\link{random_binomial_walk}()},
\code{\link{random_cauchy_walk}()},
\code{\link{random_chisquared_walk}()},
\code{\link{random_displacement_walk}()},
\code{\link{random_exponential_walk}()},
\code{\link{random_f_walk}()},
\code{\link{random_gamma_walk}()},
\code{\link{random_geometric_walk}()},
\code{\link{random_hypergeometric_walk}()},
\code{\link{random_logistic_walk}()},
\code{\link{random_lognormal_walk}()},
\code{\link{random_negbinomial_walk}()},
\code{\link{random_normal_drift_walk}()},
\code{\link{random_normal_walk}()},
\code{\link{random_poisson_walk}()},
\code{\link{random_smirnov_walk}()},
\code{\link{random_t_walk}()},
\code{\link{random_uniform_walk}()},
\code{\link{random_weibull_walk}()},
\code{\link{random_wilcox_walk}()},
\code{\link{random_wilcoxon_sr_walk}()}

Other Discrete Distribution: 
\code{\link{discrete_walk}()},
\code{\link{random_binomial_walk}()},
\code{\link{random_displacement_walk}()},
\code{\link{random_geometric_walk}()},
\code{\link{random_hypergeometric_walk}()},
\code{\link{random_negbinomial_walk}()},
\code{\link{random_poisson_walk}()},
\code{\link{random_smirnov_walk}()},
\code{\link{random_wilcox_walk}()},
\code{\link{random_wilcoxon_sr_walk}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Discrete Distribution}
\concept{Generator Functions}
