% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbenttest.R
\name{rbenttest}
\alias{rbenttest}
\title{test the existence of change point in the bent line regression}
\usage{
rbenttest(y, z, x, NB = 1000, myseed = 1)
}
\arguments{
\item{y}{A vector of response}

\item{z}{A vector of covariates}

\item{x}{A numeric variable with change point}

\item{NB}{resampling times}

\item{myseed}{set seed}
}
\value{
A list with the elements
\item{Tn}{The statistic based on original data.}
\item{Tn.NB}{The statistics by wild bootstrap.}
\item{p.value}{The p-value by wild bootstrap.}
}
\description{
This function use Wilcoxon score functions for  calculating
the test statistics and p-value by wild bootstrap.
}
\examples{
# for the example of  MRS data
data(data_mrs)
x <- log(data_mrs$mass)
y <- log(data_mrs$speed)
z <- data_mrs$hopper
p.value <- rbenttest(y, cbind(1, z), x, NB = 50)$p.value

# for the example of bedload transport data
data(data_transport)
x <- data_transport$x
y <- data_transport$y
p.value <- rbenttest(y, 1, x, NB = 50)$p.value
}
\author{
Feipeng Zhang
}
\keyword{rbenttest}

