% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tiger_zctas_sf.R
\name{tiger_zctas_sf}
\alias{tiger_zctas_sf}
\title{tiger_zctas_sf}
\usage{
tiger_zctas_sf(
  output_dir = tempdir(),
  delete_files = TRUE,
  vintage = 2020,
  general = FALSE,
  sf_info = FALSE,
  do_progress = FALSE,
  datafile = NULL,
  datafile_key = NULL,
  sf_key = NULL,
  express = NULL
)
}
\arguments{
\item{output_dir}{A full directory path where the shapefile and its associated files will be downloaded.
The default is the directory defined by the value returned by \code{tempdir()}.}

\item{delete_files}{A logical which if \code{TRUE} will delete the shapefile and associated files in 'output_dir'.
The default is TRUE.}

\item{vintage}{A numeric that sets the vintage of interest. The default is 2020.}

\item{general}{A logical which if \code{TRUE} will download a less detailed, more generalized version of the county geometries.}

\item{sf_info}{A logical which if \code{TRUE} displays info on the resulting simple feature object.}

\item{do_progress}{A logical which if \code{TRUE} displays a progress bar during the download.}

\item{datafile}{A dataframe containing data that should be joined with this function's resultant simple feature object.}

\item{datafile_key}{The column name from 'datafile' dataframe used to key with the 'sf_key' column of the resultant simple feature dataframe.}

\item{sf_key}{The column from the resultant dataframe used to key with the 'datafile' dataframe.}

\item{express}{A logical expression object used to filter the resultant simple feature dataframe.
For example, one of the columns of the resultant simple feature dataframe is "STATEFP".
If you wanted to return just the geometries for Florida (which has a fips code of "12"),
then you assign 'express' equal to: expression(STATEFP == "12"). The expression will be
evaluated and only the geometries for Florida will be returned.}
}
\value{
A data frame object of class sf
}
\description{
This function performs three tasks:
\enumerate{
\item Download to an output directory a zip file from the TIGER/Line Shapefiles database.
\item Unzip the zip file and locate the shape file of interest.
\item Read and convert the shape file to a simple feature object.
}
}
\details{
Returns simple feature (sf) shapefile Zip Code Tabulation Areas(ZCTA) shapefile of the entire US.
}
\examples{
\dontrun{
  # Beware that downloading and processing Zip Code Tabulation Areas(ZCTA)
  #   shapefiles of the entire US can be time consuming
  library(downloader)
  library(sf)
  library(data.table)
  library(withr)
  library(RcensusPkg)

  # Get the sf geometries for the Zip Code Tabulation Area in the county of
  #   Middlesex, MA near Boston
  # Define a temporary, self deleting output folder for the downloaded shapefiles
  output_dir <- withr::local_tempdir()
  if(!dir.exists(output_dir)){
    dir.create(output_dir)
  }

  # Define the codes of interest in a dataframe
  mun_zcta_df <- data.frame(
    name = c(
      "Carlisle", "Concord", "Bedford",
      "Lexington", "Lexington", "Lincoln",
      "Lincoln", "Sudbury", "Wayland",
      "Weston","Waltham"
    ),
    zcta = c(
      "01741","01742","01730",
      "02420","02421","01773",
      "01731","01776","01778",
      "02493","02451"
    )
  )

  # Define an expression to filter the downloaded shapefile
  express <- expression(ZCTA5CE20 \%in\% mun_zcta_df$zcta)

  # Get the sf geometries
  mun_zcta_sf <- RcensusPkg::tiger_zctas_sf(
    vintage = 2020,
    general = TRUE,
    do_progress = TRUE,
    express = express,
    output_dir = output_dir,
    delete_files = FALSE
  )
}

}
