% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devices-properties-timeseries.R
\name{devices_properties_timeseries}
\alias{devices_properties_timeseries}
\title{Data start Properties (of devices) API methods}
\usage{
devices_properties_timeseries(
  device_id,
  property_id,
  start = NULL,
  limit = NULL,
  store_token = "option",
  token = NULL,
  silent = FALSE
)
}
\arguments{
\item{device_id}{The id of the device}

\item{property_id}{The id of the property}

\item{start}{A \code{Posixct} or \code{Date} object. The time at which to start selecting properties.}

\item{limit}{The number of properties to select}

\item{store_token}{Where your token is stored. If \code{option} it will be retrieved from the .Rprofile (not cross-session and default),
if \code{envir} it will be retrieved from environmental variables list (cross-session).}

\item{token}{A valid token created with \code{create_auth_token} or manually.
It not \code{NULL} it has higher priority then \code{store_token}}

\item{silent}{Whether to hide or show API method success messages (default \code{FALSE})}
}
\value{
A tibble showing of time and value for property of given device
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Get device properties values in a range of time
(note: this API method is bugged and waiting to be fixed by Arduino team.
Here for completeness and future developments but would not suggest using it)

Official documentation:
\href{https://www.arduino.cc/reference/en/iot/api/#api-DevicesV2-devicesV2Timeseries}{devicesV2Timeseries}
}
\examples{
\dontrun{
Sys.setenv(ARDUINO_API_CLIENT_ID = 'INSERT CLIENT_ID HERE')
Sys.setenv(ARDUINO_API_CLIENT_SECRET = 'INSERT CLIENT_SECRET HERE')
create_auth_token()

device_id = "fa7ee291-8dc8-4713-92c7-9027969e4aa1"
property_id = "d1134fe1-6519-49f1-afd8-7fe9e891e778"

devices_properties_timeseries(device_id = device_id, property_id = property_id,
 start = "2022-08-20", limit = 10)
}
}
