% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReAD.R
\name{ReAD}
\alias{ReAD}
\title{Replicability analysis across two genome-wide association studies accounting for the linkage disequilibrium structure.}
\usage{
ReAD(pa, pb)
}
\arguments{
\item{pa}{A numeric vector of p-values from study 1.}

\item{pb}{A numeric vector of p-values from study 2.}
}
\value{
A list:
\item{rLIS}{The estimated rLIS for replicability null.}
\item{fdr}{The adjusted values based on rLIS for FDR control.}
\item{loglik}{The log-likelihood value with converged estimates of the unknowns.}
\item{pi}{An estimate of the stationary probabilities of four states {(0,0), (0,1), (1,0), (1,1)}.}
\item{A}{An estimate of the 4-by-4 transition matrix.}
\item{f1}{A non-parametric estimate for the non-null probability density function in study 1.}
\item{f2}{A non-parametric estimate for the non-null probability density function in study 2.}
}
\description{
Replicability analysis across two genome-wide association studies accounting for the linkage disequilibrium structure.
}
\examples{
# Simulate p-values in two studies locally dependent via a four-state hidden Markov model
data <- SimuData(J = 10000)
p1 = data$pa; p2 = data$pb; theta1 = data$theta1; theta2 = data$theta2
# Run ReAD to identify replicable signals
res.read = ReAD(p1, p2)
sig.idx = which(res.read$fdr <= 0.05)

}
