#' Bray-Curtis dissimilarity
#'
#' This function calculates the Bray-Curtis dissimilarity between two vectors
#'
#' @param x vector
#' @param y vector
#'
#'
#'@returns A number with the Bray-Curtis dissimilarity between \code{x} and \code{y}.
#'
#'
#'@examples
#'
#'   BrayCurtisDissimilarity(c(1,2,3), c(4,5,6))
#'
#' @export
#'
BrayCurtisDissimilarity <- function(x, y) {

  numerator <- sum(abs(x - y))
  denominator <- sum(x + y)


  dist <- numerator / denominator
  return(dist)
}
