% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/source.R
\name{cr_source.default}
\alias{cr_source.default}
\title{Visualized for CR Sources}
\usage{
\method{cr_source}{default}(clone1, clone2, ...)
}
\arguments{
\item{clone1}{First vector of sequences, string-length is the same for each
nucleotide sequence ('A', 'G', 'T', 'C').}

\item{clone2}{Second vector of sequences, same string-length as for the
first vector.}

\item{...}{Any other arguments.}
}
\value{
No return value.
}
\description{
Visualization of Two clones for their convergent recombination
(CR) sources. Each sequence (NT) is represented as a colored bar (red for A,
yellow for G, blue for T and green for C) linked to its translated amino
acid sequence by a colored line, red for the first clone and blue for the
second.
}
\examples{
nt <- c("A", "G", "C", "T")
seq_len <- 15
seq_n <- c(12, 7)

# Create data
c1 <- replicate(seq_n[1],
                paste(sample(nt, seq_len, replace = TRUE), collapse = ''))
c2 <- replicate(seq_n[2],
                paste(sample(nt, seq_len, replace = TRUE), collapse = ''))

cr_source(c1, c2)

}
