% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database_tables_mimic3.R
\name{mimic3_tables}
\alias{mimic3_tables}
\alias{mimic3_table_all_patients}
\alias{mimic3_table_admissions}
\alias{mimic3_table_callout}
\alias{mimic3_table_chart_events}
\alias{mimic3_table_cpt_events}
\alias{mimic3_table_diagnoses_icd}
\alias{mimic3_table_drg_codes}
\alias{mimic3_table_icu_stays}
\alias{mimic3_table_lab_events}
\alias{mimic3_table_microbiology_events}
\alias{mimic3_table_note_events}
\alias{mimic3_table_prescriptions}
\alias{mimic3_table_procedure_events}
\alias{mimic3_table_procedures_icd}
\alias{mimic3_table_services}
\alias{mimic3_table_transfers}
\title{MIMIC-III Tables}
\usage{
mimic3_table_all_patients(table_map, db_connection)

mimic3_table_admissions(table_map, db_connection, subject_id)

mimic3_table_callout(table_map, db_connection, subject_id)

mimic3_table_chart_events(table_map, db_connection, subject_id)

mimic3_table_cpt_events(table_map, db_connection, subject_id)

mimic3_table_diagnoses_icd(table_map, db_connection, subject_id)

mimic3_table_drg_codes(table_map, db_connection, subject_id)

mimic3_table_icu_stays(table_map, db_connection, subject_id)

mimic3_table_lab_events(table_map, db_connection, subject_id)

mimic3_table_microbiology_events(table_map, db_connection, subject_id)

mimic3_table_note_events(table_map, db_connection, subject_id)

mimic3_table_prescriptions(table_map, db_connection, subject_id)

mimic3_table_procedure_events(table_map, db_connection, subject_id)

mimic3_table_procedures_icd(table_map, db_connection, subject_id)

mimic3_table_services(table_map, db_connection, subject_id)

mimic3_table_transfers(table_map, db_connection, subject_id)
}
\arguments{
\item{table_map}{A \link[dplyr:reexports]{dplyr::tibble} containing a mapping between the CDM standard
tables and fields to the user connected tables and fields.}

\item{db_connection}{A \link[DBI:dbConnect]{DBI::dbConnect} object.}

\item{subject_id}{A numeric, or coercible to numeric.}
}
\value{
A \link[dplyr:reexports]{dplyr::tibble} containing pre-coordinated patient information from the connected database.
}
\description{
A collection of functions to create prearranged views of MIMIC-III patient data
when supplied with database connection information and a mapping of the connected
database.
}
\keyword{internal}
