% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_REDCap.R
\name{mod_redcap}
\alias{mod_redcap}
\alias{redcap_setup_ui}
\alias{redcap_instrument_ui}
\alias{redcap_server}
\title{REDCap Abstraction Module}
\usage{
redcap_setup_ui(id)

redcap_instrument_ui(id)

redcap_server(id, subject_id)
}
\arguments{
\item{id}{The module namespace}

\item{subject_id}{A \link[shiny:reactive]{shiny::reactive} expression containing a subject identifier.}
}
\value{
\emph{redcap_setup_ui}:
\item{tagList}{The REDCap setup/configuration UI}
\emph{redcap_instrument_ui}:
\item{tagList}{A shiny representation of a REDCap Instrument}
\emph{redcap_server}:
\item{reactiveValues}{
\itemize{
\item{all_review_status}: A \link[dplyr:reexports]{dplyr::tibble} containing the review status of
all previously reviewed individuals.
\item{instrument_ui}: The module instrument ui function
\item{is_configured}: A string, with module configuration status. Valid statuses
are yes' or 'no'.
\item{is_connected}: A string, with module connection status. Valid statuses are
'yes' or 'no'.
\item{moduleName}: A string, containing the module moniker.
\item{moduleType}: A string, with the module type (what does it do?)
\item{previous_selected_instrument_complete_val}: A character ("1","2","3", NA_character)
representing a REDCap review status.
\item{setup_ui}: The module setup ui function
}}
}
\description{
This module allows users to interact with REDCap Projects from within a Shiny application.
REDCap instruments are translated into native Shiny controls/widgets and allow for the
capture of abstracted information from within the R Shiny environment. Additionally, error
prone fields such as MRN and reviewer information are populated automatically, based on
user configured information, thus reducing the potential for error in abstracted
information.

This module consists of the following components:
\subsection{Module UI functions}{

\itemize{
\item{\code{redcap_setup_ui}}: The REDCap setup/configuration UI
\item{\code{redcap_instrument_ui}}: A shiny representation of a REDCap
Instrument
}
}

\subsection{Module Server function}{

\itemize{
\item{\code{redcap_server}}: The logic
}
}

\subsection{Keyboard Shortcuts}{

This module also provides a keyboard shortcut to assist with saving
abstracted patient data. The "meta" key refers to "ctrl" on Windows
and "Cmd" on Mac.
\itemize{
\item Save current instrument data: “alt + meta + s”
}
}
}
\keyword{internal}
