% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getEvents.R
\name{getEvents}
\alias{getEvents}
\title{Extract list of events from a public Facebook page or group}
\usage{
getEvents(page, token, api = "v2.9")
}
\arguments{
\item{page}{Facebook ID for the group or page.}

\item{token}{Either a temporary access token created at
\url{https://developers.facebook.com/tools/explorer} or the OAuth token 
created with \code{fbOAuth}.}

\item{api}{API version. e.g. "v2.8". \code{NULL} is the default.}
}
\description{
\code{getEvents} retrieves event information from a public Facebook group or page.
}
\examples{
\dontrun{
load("fb_oauth")
## Downloading events from Playa Vista Farmers' Market
 events <- getEvents(page="playavistaFM", token=fb_oauth)
}
}
\author{
Pablo Barbera \email{pablo.barbera@nyu.edu}
}
\seealso{
\code{\link{getPage}}, \code{\link{fbOAuth}}
}

