% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGroup.R
\name{getGroup}
\alias{getGroup}
\title{Extract list of posts from a public Facebook group}
\usage{
getGroup(group_id, token, n = 25, since = NULL, until = NULL,
  feed = TRUE, api = NULL)
}
\arguments{
\item{group_id}{Facebook ID for the group. Note that this is different from
the name on the URL. You can use \code{searchGroup} to find the ID.}

\item{token}{Either a temporary access token created at
\url{https://developers.facebook.com/tools/explorer} or the OAuth token 
created with \code{fbOAuth}.}

\item{n}{Number of posts of page to return. Note that number can be sometimes
higher or lower, depending on status of API.}

\item{since}{A UNIX timestamp or strtotime data value that points to
the start of the time range to be searched. For more information on the
accepted values, see: \url{http://php.net/manual/en/function.strtotime.php}}

\item{until}{A UNIX timestamp or strtotime data value that points to
the end of the time range to be searched. For more information on the
accepted values, see: \url{http://php.net/manual/en/function.strtotime.php}}

\item{feed}{If \code{TRUE}, the function will also return posts on the group
that were made by others (not only the admin of the group). Note that, unlike
in \code{getPage}, here \code{TRUE} is the default option.}

\item{api}{API version. e.g. "v2.8". \code{NULL} is the default.}
}
\description{
\code{getGroup} retrieves information from a public Facebook group.
}
\examples{
\dontrun{
## Find Facebook ID for R-Users Facebook group
load("fb_oauth")
ids <- searchGroup(name="rusers", token=fb_oauth)
 ids[1,] # id = 18533493739
## Downloading posts from R-Users Facebook group
 group <- getGroup(group_id=18533493739, token=fb_oauth)
## Downloading posts from R-Users Facebook group in January 2013
 group <- getGroup(group_id=18533493739, token=fb_oauth,
	since='2013/01/01', until='2013/01/31')
}
}
\author{
Pablo Barbera \email{pablo.barbera@nyu.edu}
}
\seealso{
\code{\link{getUsers}}, \code{\link{getPost}}, \code{\link{fbOAuth}}
}

