% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fold.R
\name{folding.test}
\alias{folding.test}
\title{Perform the folding test of unimodality}
\usage{
folding.test(X)
}
\arguments{
\item{X}{$nxd$ matrix (n observations, d dimensions)}
}
\value{
1 if unimodal, 0 if multimodal
}
\description{
Perform the folding test of unimodality
}
\examples{
library(MASS)
n = 10000
d = 3
mu = c(0,0,0)
Sigma = matrix(c(1,0.5,0.5,0.5,1,0.5,0.5,0.5,1), ncol = d)
X = mvrnorm(n = n, mu = mu, Sigma = Sigma)
m = folding.test(X)

}
