% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameter_estimation.R
\name{Laplace_sampling_MCMC}
\alias{Laplace_sampling_MCMC}
\title{Laplace-sampling MCMC for Generalized Linear Gaussian Process Models}
\usage{
Laplace_sampling_MCMC(
  y,
  units_m,
  mu,
  Sigma,
  ID_coords,
  ID_re = NULL,
  sigma2_re = NULL,
  family,
  control_mcmc,
  invlink = NULL,
  Sigma_pd = NULL,
  mean_pd = NULL,
  messages = TRUE
)
}
\arguments{
\item{y}{Numeric vector of responses of length \eqn{n}.
For \code{family = "binomial"} this is the number of successes,
for \code{family = "poisson"} counts, and for \code{family = "gaussian"} real values.}

\item{units_m}{Numeric vector giving the binomial totals (number of trials)
when \code{family = "binomial"}; ignored for other families (can be \code{NULL}).}

\item{mu}{Numeric vector of length equal to the number of unique locations
providing the mean of the latent spatial process on the link scale.}

\item{Sigma}{Numeric positive-definite covariance matrix for the latent spatial
process \eqn{S} at the unique locations referenced by \code{ID_coords}.}

\item{ID_coords}{Integer vector of length \eqn{n} mapping each response in
\code{y} to a row/column of \code{Sigma} (i.e., the index of the corresponding location).}

\item{ID_re}{Optional matrix or data.frame with one column per unstructured
random effect (RE). Each column is an integer vector of length \eqn{n}
mapping observations in \code{y} to RE levels (e.g., cluster, survey, etc.).
Use \code{NULL} to exclude REs.}

\item{sigma2_re}{Optional named numeric vector of RE variances. Names must
match the column names of \code{ID_re}. Ignored if \code{ID_re = NULL}.}

\item{family}{Character string: one of \code{"gaussian"}, \code{"binomial"},
or \code{"poisson"}.}

\item{control_mcmc}{List of control parameters:
\describe{
  \item{n_sim}{Total number of MCMC iterations (including burn-in).}
  \item{burnin}{Number of initial iterations to discard.}
  \item{thin}{Thinning interval for saving samples.}
  \item{h}{Initial step size for the Gaussian proposal. Defaults to \eqn{1.65 / n_\mathrm{tot}^{1/6}} if not supplied.}
  \item{c1.h, c2.h}{Positive tuning constants for adaptive step-size updates.}
}}

\item{invlink}{Optional inverse-link function. If \code{NULL}, defaults are used:
\code{identity} (gaussian), \code{plogis} (binomial), and \code{exp} (poisson).}

\item{Sigma_pd}{Optional precision matrix used in the Laplace approximation.
If \code{NULL}, it is obtained internally at the current mode.}

\item{mean_pd}{Optional mean vector used in the Laplace approximation.
If \code{NULL}, it is obtained internally as the mode of the integrand.}

\item{messages}{Logical; if \code{TRUE}, prints progress and acceptance diagnostics.}
}
\value{
An object of class \code{"mcmc.RiskMap"} with components:
\describe{
  \item{samples}{A list containing posterior draws. Always includes
                \code{$S} (latent spatial field). If \code{ID_re} is supplied,
                each unstructured RE is returned under \code{$<re_name>}.}
  \item{tuning_par}{Numeric vector of step sizes (\code{h}) used over iterations.}
  \item{acceptance_prob}{Numeric vector of Metropolis–Hastings acceptance probabilities.}
}
}
\description{
Runs Markov chain Monte Carlo (MCMC) sampling using a Laplace
approximation for Generalized Linear Gaussian Process Models (GLGPMs).
The latent Gaussian field is integrated via a second-order Taylor
expansion around the mode, and a Gaussian proposal is used for
Metropolis–Hastings updates with adaptive step-size tuning.
}
\details{
The algorithm alternates between:
\enumerate{
  \item Locating the mode of the joint integrand for the latent variables
        (via \code{maxim.integrand}) when \code{Sigma_pd} and \code{mean_pd}
        are not provided, yielding a Gaussian approximation.
  \item Metropolis–Hastings updates using a Gaussian proposal centered at
        the current approximate mean with proposal variance governed by \code{h}.
        The step size is adapted based on empirical acceptance probability.
}

Dimensions must be consistent:
\code{length(y) = n}, \code{nrow(Sigma) = ncol(Sigma) = n_loc},
and \code{length(ID_coords) = n} with entries in \eqn{1,\dots,n_\mathrm{loc}}.
If \code{ID_re} is provided, each column must have length \eqn{n}; when
\code{sigma2_re} is supplied, it must be named and match \code{colnames(ID_re)}.
}
\section{Default links}{

The default inverse links are: identity (gaussian), logistic (binomial),
and exponential (poisson). Supply \code{invlink} to override.
}

\seealso{
\code{\link{maxim.integrand}}
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Claudio Fronterre \email{c.fronterre@lancaster.ac.uk}
}
