% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal_Tests.R
\name{KSLTest}
\alias{KSLTest}
\title{Kolmogorov-Smirnov-Lilliefors Test}
\usage{
KSLTest(data, alpha = 0.05, j = 1, warn = T)
}
\arguments{
\item{data}{The data of a univariate distribution for which the test statistic is computed (vector)}

\item{alpha}{The two-sided decision threshold used for hypothesis-testing (scalar)}

\item{j}{The # hypotheses tested; used to compute a Bonferonni correction, if applicable;
should remain at its default if multiple testing is not an issue (scalar)}

\item{warn}{Used for printing a warning message when negative values are imputed to 0.0 (boolean)}
}
\value{
An object including the test statistic, p-value, and a significance flag (list)
}
\description{
This function computes the Lilliefors variant of the one-sample Kolmogorov-Smirnov test.
}
\details{
Molin & Abdi's (1998) algorithmic approximation of p-values is used for hypothesis-testing.
Note that this algorithm requires the imputation of 0.0 for negative output when p-values
would otherwise be low in value (< 0.001) using other methods. A similar issue with extremely
large values requires the imputation of 1.0 for values larger than 1.0 when p > .99.
}
\examples{
values <- rnorm(100)
x <- KSLTest(data = values)
}
\references{
Lilliefors, H.W. (1967). On the Kolmogorov-Smirnov Test for Normality with Mean and Variance Unknown. Journal of the American Statistical Association, 62, 399-402.

            Molin, P., & Abdi, H. (1998). New Tables and numerical approximation for the KolmogorovSmirnov/Lillierfors/Van Soest test of normality.
}
