% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal_Tests.R
\name{chisqTest}
\alias{chisqTest}
\title{Chi-Square Test}
\usage{
chisqTest(data, alpha = 0.05, j = 1, df = 3)
}
\arguments{
\item{data}{Data of a univariate distribution for which the test statistic is computed
(vector)}

\item{alpha}{The two-sided decision threshold used for hypothesis-testing}

\item{j}{The # hypotheses tested; used to compute a Bonferonni correction, if applicable;
should remain at its default if multiple testing is not an issue (scalar)}

\item{df}{The degrees of freedom used to test for significance against the sampling
distribution (scalar)}
}
\value{
An object including the test statistic, p-value, and a significance flag (list)
}
\description{
This function computes the chi-square test for normality.
}
\details{
Bins are created by cutting the data to ensure that values within these intervals would be
equally probable if data are normal (Moore, 1986). By default, this function assumes
that all relevant parameters (mu, sigma) are estimators, fixing the degrees of freedom
at df = 3.
}
\examples{
values <- rnorm(100)
x <- chisqTest(data = values)
}
\references{
Moore, D.S., (1986) Tests of the chi-squared type. In: D'agostino, R.B. and Stephens, M.A., eds.: Goodness-of-Fit Techniques. Marcel Dekker, New York.
}
