% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_correlation.R
\name{weighted.corr}
\alias{weighted.corr}
\title{Weighted bivariate correlation}
\usage{
weighted.corr(x, y, w, na.rm = TRUE)
}
\arguments{
\item{x}{(numeric vector) Variable of interest x for computing the correlation}

\item{y}{(numeric vector) Variable of interest y for computing the correlation}

\item{w}{(numeric vector) Vector with the weights}

\item{na.rm}{(bool) if TRUE: Excludes missing values before computing the correlation}
}
\value{
Scalar containing the Pearson correlation coefficient
}
\description{
Computes the weighted Pearson correlation coefficient of two numeric vectors.
}
\examples{
data(df_talis18) 

weighted.corr(x = df_talis18$t3stake, y = df_talis18$t3team, w = df_talis18$tchwgt)
}
