% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zfsample.R
\name{zfsample}
\alias{zfsample}
\title{Zero-fixed (re)sampling}
\usage{
zfsample(x, replace = FALSE)
}
\arguments{
\item{x}{Either a vector of one or more elements from which to choose, or a positive integer.}

\item{replace}{Should sampling be with replacement?}
}
\value{
a vector of the same length of 'x' with elements drawn from 'x'.
}
\description{
This function builds on \code{\link[base]{sample}} to provide sampling from a vector, but with all 
zero entries fixed. This way, \code{zfsample(c(0,1,0,2))} may result in (0,1,0,2) or (0,2,0,1), but the 
positions that were initially zero will remain zeroed.
}
\section{Details}{

The actual sampling is done by \code{\link[base]{sample}}, so its help page should be checked
for details on the parameter handling. The parameter 'size' is always passed as \code{length(x)},
and 'prob' is not supported.
}
\examples{
# Sampling without replacement
zfsample(c(0,1,2,0,3,4,0))
# Sampling with replacement
zfsample(c(0,1,2,0,3,4,0), replace=TRUE)
# With no zeroes, zfsample just calls sample
set.seed(42); s1<-sample(c(1,2,3,4,5,6))
set.seed(42); s2<-zfsample(c(1,2,3,4,5,6))
all.equal(s1, s2)
}

