% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.vector.phylo.R
\name{as.vector.phylo}
\alias{as.vector.phylo}
\title{Vectorize a Phylogenetic Tree}
\usage{
\method{as.vector}{phylo}(x, mode = "any")
}
\arguments{
\item{x}{A object of class phylo}

\item{mode}{The same as \code{base::as.vector}. But only numeric
output in vector form is accepted for other functions in \code{Rtropical}}
}
\value{
A vector with its elements the distance between two leaves of the tree.
}
\description{
Computes the cophenetic distance and outputs them in a vector
of a phylogenetic tree in \code{phylo} object
}
\examples{
library(ape)
tree <- rcoal(5)
tree_vec <- as.vector(tree)

}
