% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eva_functions.R
\name{empdisl}
\alias{empdisl}
\title{Empirical Distribution Function}
\usage{
empdisl(x, nyr)
}
\arguments{
\item{x}{A numeric vector or matrix representing the discharge values.}

\item{nyr}{An integer representing the number of years.}
}
\value{
A data frame containing the following columns:
\describe{
\item{\code{emp.RP}}{Empirical return period}
\item{\code{haz.RP}}{Hazen return period}
\item{\code{gumbel}}{Gumbel frequency}
\item{\code{emp.f}}{Empirical frequency}
\item{\code{emp.hazen}}{Empirical Hazen frequency}
\item{\code{Q}}{Discharge values}
}
}
\description{
This function calculates the empirical distribution function for a given dataset,
with a focus on low values
}
\examples{
x <- c(10, 20, 30, 40, 50)
nyr <- 5
empdisl(x, nyr)

}
