% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trend_functions.R
\name{tsEvaTransformSeriesToStationaryMMXTrend}
\alias{tsEvaTransformSeriesToStationaryMMXTrend}
\title{tsEvaTransformSeriesToStationaryMMXTrend}
\usage{
tsEvaTransformSeriesToStationaryMMXTrend(timeStamps, series, timeWindow)
}
\arguments{
\item{timeStamps}{A vector of time stamps corresponding to the observations in the series.}

\item{series}{A vector of the time series data.}

\item{timeWindow}{The size of the time window used for detrending.}
}
\value{
A list containing the following components:
\describe{
\item{\code{runningStatsMulteplicity}}{The multiplicity of running statistics.}
\item{\code{stationarySeries}}{The stationary series after removing the trend.}
\item{\code{trendSeries}}{The trend component of the series.}
\item{\code{trendSeriesNonSeasonal}}{NULL (not used).}
\item{\code{trendError}}{The error on the trend component.}
\item{\code{stdDevSeries}}{The standard deviation series.}
\item{\code{stdDevSeriesNonSeasonal}}{NULL (not used).}
\item{\code{stdDevError}}{The error on the standard deviation series.}
\item{\code{timeStamps}}{The time stamps.}
\item{\code{nonStatSeries}}{The original non-stationary series.}
\item{\code{statSer3Mom}}{The running mean of the third moment of the stationary series.}
\item{\code{statSer4Mom}}{The running mean of the fourth moment of the stationary series.}
}
}
\description{
\code{tsEvaTransformSeriesToStationaryMMXTrend}
transforms a time series to a stationary one by focusing on the monthly maximum values.
The trend and slowly varying amplitude are computed on the monthly maximum values.
}
\examples{
timeAndSeries <- ArdecheStMartin
timeStamps <- ArdecheStMartin[,1]
series <- ArdecheStMartin[,2]
# select only the 5 latest years
yrs <- as.integer(format(timeStamps, "\%Y"))
tokeep <- which(yrs >= 2015)
timeStamps <- timeStamps[tokeep]
series <- series[tokeep]
timeWindow <- 365 # 1 year
result <- tsEvaTransformSeriesToStationaryMMXTrend(timeStamps, series, timeWindow)
plot(result$trendSeries)

}
\seealso{
\code{\link[=tsEvaDetrendTimeSeries]{tsEvaDetrendTimeSeries()}}, \code{\link[=tsEvaNanRunningVariance]{tsEvaNanRunningVariance()}},
\code{\link[=tsEvaNanRunningMean]{tsEvaNanRunningMean()}}, \code{\link[=tsEvaNanRunningStatistics]{tsEvaNanRunningStatistics()}}
}
