
<!-- README.md is generated from README.Rmd. Please edit that file -->

# Rtumblr <img src="man/figures/logo.png" align="right" height="139" />

<!-- badges: start -->

[![CRAN
status](https://www.r-pkg.org/badges/version/Rtumblr)](https://CRAN.R-project.org/package=Rtumblr)
[![R-CMD-check](https://github.com/schochastics/Rtumblr/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/schochastics/Rtumblr/actions/workflows/R-CMD-check.yaml)
[![Codecov test
coverage](https://codecov.io/gh/schochastics/Rtumblr/branch/main/graph/badge.svg)](https://app.codecov.io/gh/schochastics/Rtumblr?branch=main)
<!-- badges: end -->

Rtumblr is a wrapper for the official tumblr API. (An [existing
CRAN](https://CRAN.R-project.org/package=tumblR) package has been
archived)

## Installation

You can install the development version of Rtumblr like so:

``` r
devtools::install_github("schochastics/Rtumblr")
```

## API keys

You need to register an app here: <https://www.tumblr.com/oauth/apps>
Then, create an environment variable called “RTUMBLR_TOKEN” (for
instance in `.Renviron`) from the consumer_key and the consumer_secret
as follows. If you have

``` r
consumer_key = 123456789
consumer_secret = abcdefghi
```

Then your environment variable RTUMBLR_TOKEN should be
`123456789;abcdefghi`

## Usage

Most API endpoints only work with your own account. The ones already
implemented include:

- `get_blog_blocks()`: get a list of accounts you blocked
- `get_blog_likes()`: get a list of posts you liked
- `get_blog_followers()`: get your followers
- `get_blog_following()`: get accounts you follow

Implemented endpoints that work with any account are:

- `get_blog_avatar()`: get the avatar of a blog
- `get_blog_info()`: get the general info of a blog
- `get_blog_posts()`: get the posts of a blog
- `get_posts_tag()`: get posts with a specific tag.

All function return a tibble (or list of tibble). To get information
about columns, see the official API documentation:
<https://www.tumblr.com/docs/en/api/v2>
