% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bc.IdBC.R
\name{IdBC}
\alias{IdBC}
\title{IdBC (Identity Bias Correction) method}
\description{
Always return X1 / X0 as correction.
}
\details{
Only for comparison.
}
\examples{
## Three bivariate random variables (rnorm and rexp are inverted between ref
## and bias)
XY = SBCK::dataset_gaussian_exp_2d(2000)
X0 = XY$X0 ## Biased in calibration period
Y0 = XY$Y0 ## Reference in calibration period
X1 = XY$X1 ## Biased in projection period


## Bias correction
## Step 1 : construction of the class IdBC
idbc = SBCK::IdBC$new() 
## Step 2 : Fit the bias correction model
idbc$fit( Y0 , X0 , X1 )
## Step 3 : perform the bias correction
Z = idbc$predict(X1,X0) 
## Z$Z0 # == X0
## Z$Z1 # == X1
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-IdBC-new}{\code{IdBC$new()}}
\item \href{#method-IdBC-fit}{\code{IdBC$fit()}}
\item \href{#method-IdBC-predict}{\code{IdBC$predict()}}
\item \href{#method-IdBC-clone}{\code{IdBC$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IdBC-new"></a>}}
\if{latex}{\out{\hypertarget{method-IdBC-new}{}}}
\subsection{Method \code{new()}}{
Create a new IdBC object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IdBC$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A new `IdBC` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IdBC-fit"></a>}}
\if{latex}{\out{\hypertarget{method-IdBC-fit}{}}}
\subsection{Method \code{fit()}}{
Fit the bias correction method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IdBC$fit(Y0, X0, X1 = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Y0}}{[matrix: n_samples * n_features] Observations in calibration}

\item{\code{X0}}{[matrix: n_samples * n_features] Model in calibration}

\item{\code{X1}}{[matrix: n_samples * n_features] Model in projection, can be
NULL for stationary BC method}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IdBC-predict"></a>}}
\if{latex}{\out{\hypertarget{method-IdBC-predict}{}}}
\subsection{Method \code{predict()}}{
Predict the correction. Use named keywords to use stationary or
non-stationary method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IdBC$predict(X1 = NULL, X0 = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X1}}{[matrix: n_samples * n_features or NULL] Model in projection}

\item{\code{X0}}{[matrix: n_samples * n_features or NULL] Model in calibration}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[matrix or list] Return X1 and / or X0
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IdBC-clone"></a>}}
\if{latex}{\out{\hypertarget{method-IdBC-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IdBC$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
