% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.shuffle.R
\name{SchaakeShuffleMultiRef}
\alias{SchaakeShuffleMultiRef}
\title{ShaakeShuffleMultiRef class}
\description{
Match the rank structure of X with them of Y by reordering X.
}
\details{
Can keep multiple features to keep the structure of X.
}
\examples{
X0 = matrix( stats::runif(50) , ncol = 2 )
Y0 = matrix( stats::runif(50) , ncol = 2 )
ssmr = SchaakeShuffleMultiRef$new( lag_search = 3 , lag_keep = 1 , cond_cols = 1 )
ssmr$fit(Y0)
Z0 = ssmr$predict(X0)

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{cond_cols}}{[vector of integer] The conditioning columns}

\item{\code{lag_search}}{[integer] Number of lag to take into account}

\item{\code{lag_keep}}{[integer] Number of lag to keep}

\item{\code{Y0}}{[matrix] Reference data}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SchaakeShuffleMultiRef-new}{\code{SchaakeShuffleMultiRef$new()}}
\item \href{#method-SchaakeShuffleMultiRef-fit}{\code{SchaakeShuffleMultiRef$fit()}}
\item \href{#method-SchaakeShuffleMultiRef-predict}{\code{SchaakeShuffleMultiRef$predict()}}
\item \href{#method-SchaakeShuffleMultiRef-clone}{\code{SchaakeShuffleMultiRef$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SchaakeShuffleMultiRef-new"></a>}}
\if{latex}{\out{\hypertarget{method-SchaakeShuffleMultiRef-new}{}}}
\subsection{Method \code{new()}}{
Create a new ShaakeShuffleMultiRef object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SchaakeShuffleMultiRef$new(lag_search, lag_keep, cond_cols = base::c(1))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lag_search}}{[integer] Number of lag to take into account}

\item{\code{lag_keep}}{[integer] Number of lag to keep}

\item{\code{cond_cols}}{[vector of integer] The conditioning columns}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `ShaaleShuffleMultiRef` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SchaakeShuffleMultiRef-fit"></a>}}
\if{latex}{\out{\hypertarget{method-SchaakeShuffleMultiRef-fit}{}}}
\subsection{Method \code{fit()}}{
Fit the model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SchaakeShuffleMultiRef$fit(Y0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Y0}}{[vector] The reference vector}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SchaakeShuffleMultiRef-predict"></a>}}
\if{latex}{\out{\hypertarget{method-SchaakeShuffleMultiRef-predict}{}}}
\subsection{Method \code{predict()}}{
Fit the model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SchaakeShuffleMultiRef$predict(X0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X0}}{[vector] The vector to apply shuffle}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Z0 [vector] data shuffled
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SchaakeShuffleMultiRef-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SchaakeShuffleMultiRef-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SchaakeShuffleMultiRef$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
