% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entropy.R
\name{gene_hom}
\alias{gene_hom}
\title{Find the Homogeneity of a Gene Within a Population}
\usage{
gene_hom(expr, unit = "log2", normalise = TRUE, transpose = FALSE)
}
\arguments{
\item{expr}{A vector or matrix of gene expressions. For the matrix, genes
should be represented as rows and cells as columns.}

\item{unit}{The units to be parsed to the entropy function.}

\item{normalise}{A logical value representing whether the gene frequencies
should be normalised into a distribution.}

\item{transpose}{A legical value representing whether the matrix should be
transposed before any calculations are performed.}
}
\value{
A vector of the information contained in the distribution of each
gene. The higher this is, the more homogeneous the gene is within the cell
population.
}
\description{
Find the Homogeneity of a Gene Within a Population
}
\examples{
#Creating Data
gene1 <- c(0,0,0,0,1,2,3)
gene2 <- c(5,5,3,2,0,0,0)
gene3 <- c(2,0,2,1,3,0,1)
gene4 <- c(3,3,3,3,3,3,3)
gene5 <- c(0,0,0,0,5,0,0)
gene_counts <- matrix(c(gene1,gene2,gene3,gene4,gene5), ncol = 5)
rownames(gene_counts) <- paste0("cell",1:7)
colnames(gene_counts) <- paste0("gene",1:5)

#Calculating Homogeneity For Each Gene
gene_hom(gene1)
gene_hom(gene2)
gene_hom(gene3)
gene_hom(gene4)
gene_hom(gene5)

#Calculating Homogeneity For a Matrix
gene_hom(gene_counts)
}
