#' @title Sample dataset of abundance of genera in tropical moist forest
#' @name genus2
#' @docType data
#' @author CoForChange project
# @keywords datasets
#' @note The use of this dataset for publication must make reference to the CoForChange project.
#' @description genus2 gives the abundance of 15 common tree genera in the tropical moist forest
#' of the Congo-Basin and 46 geo-referenced environmental variables on one thousand 8 by 8 km plots
#'  (observations). Each plot's data was obtained by aggregating the data measured on a variable
#'  number of previously sampled 0.5 ha sub-plots. Geo-referenced environmental variables were
#'  used to describe the physical factors as well as vegetation characteristics.
#'  23 physical factors were used pertaining the description of topography, geology and rainfall
#'  of each plot. Vegetation is characterized through 16-days enhanced vegetation index (EVI) data.
#' @references S. Gourlet-Fleury et al. (2009--2014) CoForChange project: \url{https://coforchange.cirad.fr/}
#' @references C. Garcia et al. (2013--2015) CoForTips project: \url{https://www.cofortips.org/}
#' @format
#' \tabular{ll}{
#'    \code{gen1 to gen15} \tab abundance of 15 common genera.\cr
#'    \code{evi_1 to evi_23} \tab 16-days enhanced vegetation indexes.\cr
#'    \code{MIR and NIR} \tab Middle-Infrared and Near-Infrared channels.\cr
#'    \code{pluvio_an} \tab mean annual rainfall.\cr
#'    \code{pluvio_1 to pluvio_12} \tab monthly rainfalls.\cr
#'    \code{altitude} \tab above-sea level in meters.\cr
#'    \code{mois_sec_50 and mois_sec_50} \tab ??? \cr
#'    \code{CWD, awd and mcwd} \tab ??? \cr
#'    \code{wetness} \tab ??? \cr
#'    \code{center_x and center_y} \tab longitude and latitude of the plot centers.\cr
#'    \code{geology} \tab 5-level geological substrate.\cr
#'    \code{inventory} \tab forest concession id number.\cr 
#'    \code{surface} \tab sampled area.\cr
#' }
#'
NULL
