% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_functions.R
\name{SCOPRO}
\alias{SCOPRO}
\title{SCOPRO}
\usage{
SCOPRO(
  norm_vitro,
  norm_vivo,
  cluster_vitro,
  cluster_vivo,
  name_vivo,
  marker_stages_filter,
  threshold = 0.1,
  number_link = 1,
  fold_change = 3,
  threshold_fold_change = 0.1,
  marker_stages,
  selected_stages
)
}
\arguments{
\item{norm_vitro}{Norm count matrix (n_genes X n_cells) for in vitro dataset}

\item{norm_vivo}{Norm count matrix (n_genes X n_cells) for in vivo dataset}

\item{cluster_vitro}{cluster for in vitro dataset}

\item{cluster_vivo}{cluster for in vivo dataset}

\item{name_vivo}{name of the in vivo stage on which SCOPRO is run}

\item{marker_stages_filter}{output from the function \emph{filter_in_vitro}}

\item{threshold}{Numeric value. For a given gene, the jaccard index between the links from the in vivo and in vitro datasets is computed. If the jaccard index is above \emph{threshold}, then the gene is considered to be conserved between the two datasets.}

\item{number_link}{Numeric value. For a given gene in the in vivo dataset with links above \emph{number_link}, the jaccard index between the links from in vitro and in vivo dataset is computed.}

\item{fold_change}{Numeric value. For a given gene, the fold change between all the other genes is computed. If fold change is above \emph{fold_change}, then there is a link with weight 1 between the two genes.}

\item{threshold_fold_change}{Numeric value. Above \emph{threshold} the fold change between genes is computed. Below \emph{threshold} the difference between genes is computed.}

\item{marker_stages}{Second element of the list given as output by the function \emph{select_top_markers}}

\item{selected_stages}{In vivo stages for which the markers where computed with the function \emph{select_top_markers}}
}
\value{
A list with five elements:

\item{common_link}{Vector with the names of the genes conserved between \emph{name_vivo} and all the clusters in the vitro dataset}
\item{no_common_link}{Vector with the names of the genes not conserved between \emph{name_vivo} and  the clusters in the vitro dataset}
\item{link_kept}{List with the names of the genes conserved between \emph{name_vivo} and each single cluster in the vitro dataset}
\item{link_no_kept}{List with the names of the genes not conserved between \emph{name_vivo} and each single cluster in the vitro dataset}
\item{final_score}{Numeric value, given by the fraction of conserved markers of \emph{name_vivo} and each single cluster in the in vitro dataset}
}
\description{
The mean expression profile of \emph{marker_stages_filter} genes is computed for each cluster in the in vivo and in vitro dataset.
For a given cluster, a connectivity matrix is computed with number of rows and number of columns equal to the length of \emph{marker_stages_filter}. Each entry (i,j)  in the matrix can be 1 if the fold_change between gene i and gene j is above \emph{fold_change}. Otherwise is 0.
Finally the connectivity matrix of a given \emph{name_vivo} stage and all the clusters in the in vitro dataset are compared.
A gene i is considered to be conserved between \emph{name_vivo} and an in vitro cluster if the jaccard index of the links of gene i is above \emph{threshold}.
}
\examples{
load(system.file("extdata", "norm_es_vitro_small.Rda", package = "SCOPRO"))
n_es= norm_es_vitro_small
load(system.file("extdata", "norm_vivo_small.Rda", package = "SCOPRO"))
n_v = norm_vivo_small
load(system.file("extdata", "cluster_es_vitro_small.Rda", package = "SCOPRO"))
c_es=cluster_es_vitro_small
load(system.file("extdata", "cluster_vivo_small.Rda", package = "SCOPRO"))
c_v=cluster_vivo_small
load(system.file("extdata", "marker_stages_filter.Rda", package = "SCOPRO"))
m_s_f = marker_stages_filter
load(system.file("extdata", "marker_stages.Rda", package = "SCOPRO"))
m_s = marker_stages
stages = c("Late_2_cell","epiblast_4.5","epiblast_5.5","epiblast_6.5")
output_SCOPRO = SCOPRO(n_es,n_v,c_es,c_v,"Late_2_cell",m_s_f,0.1,1,3,0.1,m_s,stages)
plot_score(output_SCOPRO,m_s,m_s_f,stages,"Late_2_cell","Score","Cluster","2-cells")


}
\author{
Gabriele Lubatti \email{gabriele.lubatti@helmholtz-muenchen.de}
}
