% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{scaling}
\alias{scaling}
\title{Normalization of gene expression data}
\usage{
scaling(
  matrix,
  option,
  gene_length = NULL,
  seed = 1234,
  ffpe_artifacts = FALSE,
  model = NULL
)
}
\arguments{
\item{matrix}{a matrix-like objector of gene expression values with rows representing genes, columns representing samples or cells}

\item{option}{character value specifying the normalization method to use. Has to be one of "none", "LogNormalize", "TMM", "median_ratios", "TPM",
"SCTransform", "scran", "scater", "Linnorm".}

\item{gene_length}{a data.frame with two columns. The first column represents gene names that match with provided bulk data. The second column
represents length of each gene. Only applicable when norm_method is selected as "TPM"}

\item{seed}{random seed used for simulating FFPE artifacts. Only applicable when ffpe_artifacts is set to TRUE.}

\item{ffpe_artifacts}{logical value indicating whether to add simulated ffpe artifacts in the bulk data. Only applicable to simulation experiments in
evaluating the effect of FFPE artifacts.}

\item{model}{pre-constructed ffpe model data. Can be downloaded from github: https://github.com/Liuy12/SCdeconR/blob/master/data/ffpemodel.rda}
}
\value{
a matrix-like object with the same dimension of input object after data normalization.
}
\description{
Methods to use for data normalization.
}
\details{
refer to \code{\link{scdecon}} for more details.
}
