#' gini data
#'
#' 
#' Data from the population of districts for the 1921 Italian general census. 
#'
#'
#' @format This data frame contains the following columns:
#' 
#' \describe{
#' \item{id:}{ID number}
#' 
#' \item{district:}{district name}
#' 
#' \item{birth_rate:}{births per 1,000 population}
#' 
#' \item{death_rate:}{deaths per 1,000 population}
#' 
#' \item{marriage_rate:}{marriages per 1,000 population}
#' 
#' \item{agricultural_pop:}{percentage of males over 10 years old who work in agriculture}
#' 
#' \item{urban_population:}{percentage of population in urban areas}
#' 
#'  \item{income:}{average income}
#'  
#'  \item{altitude:}{average altitude above sea level (meters)}
#'  
#'  \item{pop_density:}{number of inhabitants per square kilometer}
#'  
#'  \item{natural_growth:}{rate of average increase of the population}
#'  
#'  \item{population:}{population of area}
#'  
#'  \item{area:}{land area (square kilometers)}
#'  
#'  \item{in_GG_sample:}{
#'  
#'= 1 if in the purposive sample selected by Gini and Galvani
#'  
#'= 0 otherwise}
#'  }
#'  
#'
#' @docType data
#'
#' @usage data(gini)
#'
#'
#'
#' @keywords datasets
#' 
#'@references Gini, C. and L. Galvani (1929). Di una applicazione del metodo rappresentativo all’ultimo
#'censimento italiano della popolazione. \emph{Annali di Statistica 6 (4)}, 1-105. The data are on pages 73–78.
#'
#' @references Lohr (2021), Sampling: Design and Analysis, 3rd Edition. Boca Raton, FL: CRC Press.
#' 
#'@references Lu and Lohr (2021), R Companion for \emph{Sampling: Design and Analysis, 3rd Edition}, 1st Edition. Boca Raton, FL: CRC Press.
#' 
#'
#' 
#' 
#' 
"gini"

