% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_lambda.R
\name{process.lambda}
\alias{process.lambda}
\title{Set up a lambda sequence}
\usage{
process.lambda(
  X,
  y,
  group,
  Z,
  type,
  alpha,
  lambda.min,
  log.lambda,
  nlambda,
  group.weight,
  ada_mult
)
}
\arguments{
\item{X}{The design matrix without intercept with the variables to be selected.}

\item{y}{The response vector.}

\item{group}{A vector indicating the group membership of each variable in X.}

\item{Z}{The design matrix of the variables to be included in the model without penalization.}

\item{type}{A string indicating the type of regression model (linear or binomial).}

\item{alpha}{Tuning parameter for the mixture of penalties at group and variable level.
A value of 0 results in a selection at group level, a value of 1
results in a selection at variable level and everything in between
is bi-level selection.}

\item{lambda.min}{An integer multiplied by the maximum lambda to define the end of the lambda sequence.}

\item{log.lambda}{A Boolean value that specifies whether the values of the lambda
sequence should be on the log scale.}

\item{nlambda}{An integer that specifies the length of the lambda sequence.}

\item{group.weight}{A vector specifying weights that are multiplied by the group
penalty to account for different group sizes.}

\item{ada_mult}{An integer that defines the multiplier for adjusting the convergence threshold.}
}
\value{
A vector with values for lambda.
}
\description{
A function that sets up a lambda sequence for a sparse group penalty.
}
