% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{nColonies}
\alias{nColonies}
\alias{nNULLColonies}
\alias{nEmptyColonies}
\title{Number of colonies in a MultiColony object}
\usage{
nColonies(multicolony)

nNULLColonies(multicolony)

nEmptyColonies(multicolony)
}
\arguments{
\item{multicolony}{\code{\link[SIMplyBee]{MultiColony-class}}}
}
\value{
integer
}
\description{
Level 0 function that returns the number of colonies in a
  MultiColony object.
}
\section{Functions}{
\itemize{
\item \code{nNULLColonies()}: Number of \code{NULL} colonies in a MultiColony object

\item \code{nEmptyColonies()}: Number of empty colonies in a MultiColony object

}}
\examples{
founderGenomes <- quickHaplo(nInd = 5, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
\dontshow{SP$nThreads = 1L}
basePop <- createVirginQueens(founderGenomes)
emptyApiary <- createMultiColony(n = 3)
emptyApiary1 <- c(createColony(), createColony())
nonEmptyApiary <- createMultiColony(basePop[2:3], n = 2)

nColonies(nonEmptyApiary)
nColonies(emptyApiary)

isEmpty(emptyApiary)
isEmpty(emptyApiary1)
isEmpty(nonEmptyApiary)
isNULLColonies(emptyApiary)
isNULLColonies(emptyApiary1)
isNULLColonies(nonEmptyApiary)

nEmptyColonies(emptyApiary)
nEmptyColonies(emptyApiary1)
nEmptyColonies(nonEmptyApiary)
nNULLColonies(emptyApiary)
nNULLColonies(emptyApiary1)
nNULLColonies(nonEmptyApiary)

}
\seealso{
\code{\link[SIMplyBee]{nNULLColonies}} and \code{\link[SIMplyBee]{nEmptyColonies}}
}
