% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequencing.R
\name{singleCell}
\alias{singleCell}
\title{Simulate single cell sequencing data}
\usage{
singleCell(tumor, pos, noise = 0)
}
\arguments{
\item{tumor}{A list which is the output of \code{\link{simulateTumor}()}.}

\item{pos}{A vector of length 3 giving the (x,y,z) coordinates of the cell to sample.}

\item{noise}{The false negative rate.}
}
\value{
A data frame with 1 row and columns corresponding to the mutations present in the cell. A 1 indicates that
the mutation is detected while a 0 indicates the mutation is not detected.
}
\description{
Simulate single cell sequencing data by selecting a cell at a specified position
}
\details{
This function selects the cell at \code{pos} (error if no cell at specified position exists) and returns
the list of mutations present in the cell. Due to technological artifacts, the false negative rate can be quite higher
(10-20 percent). To account for this,
the \code{noise} parameter introduces false negatives into the data set at the specified rate.
}
\examples{
set.seed(1126490984)
out <- simulateTumor(max_pop = 1000)
df <- singleCell(tumor = out, pos = c(0,0,0), noise = 0.1)

}
\references{
K. Jahn, J. Kupiers and N. Beerenwinkel. Tree inference for single-cell data. Genome Biology, volume 17, 2016. 
https://doi.org/10.1186/s13059-016-0936-x.
}
\author{
Phillip B. Nicol <philnicol740@gmail.com>
}
