library(testthat)

test_that("SLIC returns a list with correct components", {
  set.seed(123)
  n <- 100
  p <- 3
  X <- matrix(rnorm(n * p), ncol = p)
  beta <- runif(p, 1, 2)
  e <- sn::rsn(n = n, xi = 0, omega = 1, alpha = 5)
  Y <- as.vector(X %*% beta + e)

  result <- SLIC(X = X, Y = Y, dist_type = "skew_normal", K = 5, nk = 20)

  expect_type(result, "list")
  expect_named(result, c("MUopt", "Bopt", "MAEMUopt", "MSEMUopt", "opt", "Yopt"))

  # Bopt 应该是 p x 1 矩阵或向量
  expect_true(is.numeric(result$Bopt) || is.matrix(result$Bopt))
  expect_true(length(result$Bopt) == p || nrow(result$Bopt) == p)

  # opt 是整型向量，长度 >= p
  expect_true(is.integer(result$opt) || is.numeric(result$opt))
  expect_true(length(result$opt) >= p)

  # MUopt 与 Yopt 长度一致
  expect_equal(length(result$MUopt), length(result$Yopt))
})
