% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_cutoff.R
\name{bootstrap_cutoff}
\alias{bootstrap_cutoff}
\title{Bootstrap Cutoff for SLIDE}
\usage{
bootstrap_cutoff(uninfected, fraction = 0.1, iter = 20, level = 0.05)
}
\arguments{
\item{uninfected}{A dataframe of protein expression levels in an uninfected subset of cells. All columns must be numeric expression levels.}

\item{fraction}{Fraction of uninfected cells used for the SLIDE bootstrap. This value should reflect the size of the infected cell population relative to the uninfected cell population. Must be between >0 and <=0.2. Default is 0.1.}

\item{iter}{Iterations of the SLIDE bootstrap. Default is 20.}

\item{level}{Alpha level to determine cutoff for a significant mean distance ratio. Default is 0.05.}
}
\value{
This function bootstraps a cutoff for the mean distance ratio from the uninfected cell population by running the SLIDE procedure on a random subset of uninfected cells a specified number of times (default 20x). Only to be used if our pre-determined value of 1.2 is insufficient. Depending on how large the uninfected dataset is, this function may take many hours to complete.
}
\description{
Bootstrap Cutoff for SLIDE
}
\examples{
cutoff <- bootstrap_cutoff(uninfected = UN_sig, fraction = (nrow(I_sig)/nrow(UN_sig)), iter=1)
cutoff
}
\references{
Sen, N., Mukherjee, G., Sen, A., Bendall, S. C., Sung, P., Nolan, G. P., & Arvin, A. M. (2014). Single-Cell Mass Cytometry Analysis of Human Tonsil T Cell Remodeling by Varicella Zoster Virus. Cell Reports, 8(2), 633–645. https://doi.org/10.1016/j.celrep.2014.06.024
}
