% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SMAHP.R
\name{SMAHP}
\alias{SMAHP}
\title{Main function}
\usage{
SMAHP(
  X,
  M,
  C,
  time,
  status,
  model_option = "MCP",
  SIS_thres = "n/log(n)",
  p_adjust_option = "BH",
  p_thres = 0.05
)
}
\arguments{
\item{X}{An n by p matrix of exposures.}

\item{M}{An n by p matrix of mediators.}

\item{C}{An n by p matrix of covariates. If there are no covariates, set C = NULL.}

\item{time}{A vector of survival time of samples.}

\item{status}{A vector of status indicator: 0=alive, 1=dead.}

\item{model_option}{The penalization method used when selecting X for M. Options include MCP, elastic net and lasso. Default is MCP.}

\item{SIS_thres}{SIS thresholds. Default is "n/log(n)". Other options include "n-1", "n/2log(n)", "2n/log(n)", "3n/log(n)".}

\item{p_adjust_option}{The method for multiple correction. Option include q-value, holm, hochberg, hommel, bonferroni, BH, BY,
and fdr. Default is BH.}

\item{p_thres}{Threshold for determining significance.}
}
\value{
A list with the following components:
\item{p_final_matrix}{raw p-value matrix before adjustment}
\item{p_adjusted_matrix}{adjusted p-value matrix}
\item{p_med_matrix}{mediation-exposure matrix}
\item{outcome_model}{coefficient estimates from outcome model}
\item{med_results}{coefficient estimates from mediation model}
}
\description{
An approach for survival mediation analysis of high-dimensional proteogenomic data.
}
\examples{
\donttest{
data(example_dat)
surv_dat <- example_dat$surv_dat
SMAHP(example_dat$X, example_dat$M, example_dat$C, time = surv_dat$time, status = surv_dat$status)
}
}
