% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StepTwo.R
\name{StepTwo}
\alias{StepTwo}
\title{Select M-X pairs via SIS}
\usage{
StepTwo(
  X,
  M,
  time,
  status,
  X_sel_Y_s1,
  M_X_s1,
  M_sel_Y_s1,
  SIS_thres = "n/log(n)"
)
}
\arguments{
\item{X}{An n by p matrix of exposures.}

\item{M}{An n by p matrix of mediators.}

\item{time}{A vector of survival time of samples.}

\item{status}{A vector of status indicator: 0=alive, 1=dead.}

\item{X_sel_Y_s1}{Outputs from StepOne: A vector of selected X for Y.}

\item{M_X_s1}{Outputs from StepOne: A list of selected X for M.}

\item{M_sel_Y_s1}{Outputs from StepOne: A vector of selected M for Y.}

\item{SIS_thres}{SIS thresholds. Default is "n/log(n)". Other options include "n-1", "n/2log(n)", "2n/log(n)", "3n/log(n)".}
}
\value{
A data table with selected M, X pairs and related effect size.
}
\description{
An auxiliary function which selects M-X paris using SIS.
}
\examples{
\donttest{
data(example_dat)
surv_dat <- example_dat$surv_dat
res_step1 <- StepOne(X = example_dat$X, M = example_dat$M, time = surv_dat$time,
status = surv_dat$status, model_option = "MCP")
M_X_sel_s2 <- StepTwo(X = example_dat$X, M = example_dat$M, time = surv_dat$time,
status = surv_dat$status, X_sel_Y_s1 = res_step1$X_sel_Y_s1, M_X_s1 = res_step1$M_X_s1,
M_sel_Y_s1 = res_step1$M_sel_Y_s1)
}
}
