% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hard_filter.R
\name{hard_filter}
\alias{hard_filter}
\title{Hard filter a vcf file by depth and genotype quality (gq)}
\usage{
hard_filter(vcfR, depth = NULL, gq = NULL)
}
\arguments{
\item{vcfR}{a vcfR object}

\item{depth}{an integer representing the minimum depth for genotype calls that you
wish to retain
(e.g. 'depth = 5' would remove all genotypes with a sequencing depth of 4 reads or less)}

\item{gq}{an integer representing the minimum genotype quality for
genotype calls that you wish to retain
(e.g. 'gq = 30' would remove all genotypes with a quality score of 29 or lower)}
}
\value{
The vcfR object input, with the sites failing specified filters converted to 'NA'
}
\description{
This function requires a vcfR object as input.
The user can then specify the minimum value for depth of coverage required to retain
a called genotype (must be numeric).
Additionally, the user can specify a minimum genotype quality required to retain
a called genotype (again, must be numeric).
}
\examples{
hard_filter(vcfR = SNPfiltR::vcfR.example, depth = 5)
hard_filter(vcfR = SNPfiltR::vcfR.example, depth = 5, gq = 30)
}
