% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/som.add.numbers.R
\name{som.add.numbers}
\alias{som.add.numbers}
\title{Add Neuron Numbering}
\usage{
som.add.numbers(SOM, scale = 1, col = "black")
}
\arguments{
\item{SOM}{the SOM object}

\item{scale}{a number to scale up or down the size of the text}

\item{col}{the color of the text}
}
\value{
Called for its effect.
}
\description{
Add the neuron numbering scheme to the SOM plot
}
\examples{
#Read example SOM data
som_model <- readRDS(system.file("extdata", "SOM_HIFa.rds", package = "SOMMD"))
#Plot the som
plot(som_model, type = "count", bgcol=c("red", "blue", "yellow", "green"), shape='straight')
#Add neuron numbers on the som
som.add.numbers(som_model, scale=0.5, col="black")

}
\author{
Stefano Motta \email{stefano.motta@unimib.it}
}
