% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trj2pdb.R
\name{trj2pdb}
\alias{trj2pdb}
\title{Extract frame to pdb}
\usage{
trj2pdb(trj, frame, filename)
}
\arguments{
\item{trj}{a trj object.}

\item{frame}{the frame to extract.}

\item{filename}{for the output pdb file}
}
\value{
a pdb object of the selected frame

Called for its effect.
}
\description{
Extract a trj frame to a pdb object
}
\examples{
\donttest{
# Read the trajectory
trj <- read.trj(trjfile = system.file("extdata", "HIF2a-MD.xtc", package = "SOMMD"),
  topfile = system.file("extdata", "HIF2a.gro", package = "SOMMD"))
# Write the pdb file for a specific frame
trj2pdb(trj = trj, frame=5, filename = tempfile(fileext = '.pdb' ))
}

}
\author{
Stefano Motta \email{stefano.motta@unimib.it}
}
