% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_data.R
\name{generate_data}
\alias{generate_data}
\title{Generate Data of Varying Complexity}
\usage{
generate_data(
  n_claims_per_period,
  n_periods = 40,
  complexity = c(1:5),
  data_type = c("claims", "payments", "incurred"),
  random_seed = NULL,
  verbose = TRUE,
  covariates_obj = NULL
)
}
\arguments{
\item{n_claims_per_period}{\strong{expected} number of claims per period (equals
the total expected number of claims divided by \code{n_periods}).}

\item{n_periods}{number of accident periods considered (equals number of
claims development periods considered); default 40.}

\item{complexity}{integer from 1 (simplest) to 5 (most complex); see Details.}

\item{data_type}{a character vector specifying output data types. By default
the function will output all 3 datasets (claims, payments, incurred), but the
user may choose to output only a subset.}

\item{random_seed}{optional seed for random number generation for
reproducibility.}

\item{verbose}{logical; if \code{TRUE} print a message about the data generated.}

\item{covariates_obj}{a SynthETIC \code{\link[SynthETIC]{covariates}} object (requires \verb{SynthETIC >= 1.1.0}). Defaults to \code{NULL}.}
}
\value{
A named list of dataframes:
\tabular{ll}{
\code{claim_dataset} \tab A dataset of claim records that takes the same structure
as \code{\link[SynthETIC]{test_claim_dataset}}, with each row representing a
unique claim. \cr
\code{payment_dataset} \tab A dataset of partial payment records that takes the
same structure as \code{\link[SynthETIC]{test_transaction_dataset}}, with
each row representing a unique payment. \cr
\code{incurred_dataset} \tab A dataset of transaction records that tracks how the
case estimates change over time. Takes the same structure as
\code{\link{test_incurred_dataset}}, with each row representing a transaction
(any of claim notification, settlement, a payment, or a case estimate
revision). \cr
\code{covariates_data} \tab Only if \code{covariates_obj} is not NULL, in which case
it will return a SynthETIC \code{\link[SynthETIC]{covariates_data}} object.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} \cr \cr
Generates datasets under 5 scenarios of different levels of complexity (here
"complexity" means the level of difficulty of analysis).
}
\details{
\code{generate_data()} produces datasets of varying levels of complexity,
where 1 represents the simplest, and 5 represents the most complex:
\itemize{
\item 1 – simple, homogeneous claims experience, with zero inflation.
\item 2 – slightly more complex than 1, with dependence of notification delay and
settlement delay on claim size, and 2\% p.a. base inflation.
\item 3 – steady increase in claim processing speed over occurrence periods (i.e.
steady decline in settlement delays).
\item 4 – inflation shock at time 30 (from 0\% to 10\% p.a.).
\item 5 – default distributional models, with complex dependence structures (e.g.
dependence of settlement delay on claim occurrence period).
}

We remark that this by no means defines the limits of the complexity that can
be generated with \code{SPLICE}. This function is provided for the convenience of
users who wish to generate (a collection of) datasets under some
representative scenarios. If more complex features are required, the user is
free to modify the distributional assumptions (which, of course, requires
more thoughts and coding) to achieve their purposes.
}
\examples{
# Generate datasets of full complexity
result <- generate_data(
  n_claims_per_period = 50, data_type = c('claims', 'payments'),
  complexity = 5, random_seed = 42)

# Save individual datasets
claims <- result$claim_dataset
payments <- result$payment_dataset

# Generate chain-ladder compatible dataset
CL_simple <- generate_data(
  n_claims_per_period = 50, data_type = 'claims', complexity = 1, random_seed = 42)

# To mute message output
CL_simple_2 <- generate_data(
  n_claims_per_period = 50, data_type = 'claims', verbose = FALSE, random_seed = 42)

# Ouput is reproducible with the same random_seed value
all.equal(CL_simple$claim_dataset, CL_simple_2$claim_dataset)

}
\seealso{
\code{\link[SynthETIC]{generate_claim_dataset}},
\code{\link[SynthETIC]{generate_transaction_dataset}},
\code{\link{generate_incurred_dataset}}
}
