% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqtable.R
\name{seqtable}
\alias{seqtable}
\title{Sequential Relation Table}
\usage{
seqtable(object, order = c("no", "decreasing", "increasing"), digits = 3,
  output = TRUE)
}
\arguments{
\item{object}{requires the return object from the TSSA or SSRA function}

\item{order}{sort by item mean of j?}

\item{digits}{integer indicating the number of decimal places to be used}

\item{output}{print result table?}
}
\description{
This function builds a table for the tssa and ssra object used to create a treegram
}
\details{
Takea Semantic Structure Analysis (TSSA) and Sakai Sequential Relation Analysis (SSRA) are graphical approaches
}
\examples{
# Example data based on Takeya (1991)

# Takea Semantic Structure Analysis
# ordering assesed according to the correlation coefficient and mean difference
exdat.tssa <- TSSA(exdat, m = 5, output = FALSE)
seqtable(exdat.tssa)

# Sakai Sequential Relation Analysis
# ordering assesed according to the correlation coefficient and mean difference
exdat.ssra <- SSRA(exdat, output = FALSE)
seqtable(exdat.ssra)
}
\author{
Takuya Yanagida
Keiko Sakai
}
\references{
Takeya, M. (1991). \emph{A new test theory: Structural analyses for educational information}.
Tokyo: Waseda University Press.
}
\seealso{
\code{\link{TSSA}}, \code{\link{SSRA}}, \code{\link{treegram}}, \code{\link{summary.seqtable}}
}

