% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.seqtable.R
\name{summary.seqtable}
\alias{summary.seqtable}
\title{Sequential Relationship Table Summary}
\usage{
\method{summary}{seqtable}(object, exclude = TRUE, ...)
}
\arguments{
\item{object}{requires the result object of seqtable function}

\item{exclude}{exclude lower-order paths (i.e., paths included in higher order paths)?}

\item{...}{additional arguments affecting the summary produced}
}
\value{
\tabular{ll}{
   \code{rel}  \tab relationship: sq = sequential / eq = equal \cr
   \code{var}  \tab variables involved in the sequential/equal paths \cr
}
}
\description{
\code{summary} function for the \code{seqtab} object
}
\details{
Takea Semantic Structure Analysis (TSSA) and Sakai Sequential Relation Analysis (SSRA) are graphical approaches
}
\examples{
# Example data based on Takeya (1991)

# Sakai Sequential Relation Analysis
# ordering assesed according to the correlation coefficient and mean difference
exdat.ssra <- SSRA(exdat, output = FALSE)
exdat.seqtab<- seqtable(exdat.ssra, output = FALSE)
summary(exdat.seqtab)
}
\author{
Takuya Yanagida
Keiko Sakai
}
\references{
Takeya, M. (1991). \emph{A new test theory: Structural analyses for educational information}.
Tokyo: Waseda University Press.
}
\seealso{
\code{\link{SSRA}}, \code{\link{TSSA}}
}

