% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_likelihood_generalized_2d.R
\name{log_likelihood_generalized_2d}
\alias{log_likelihood_generalized_2d}
\title{Generalized Log-Likelihood Function for 2D Copula-GEV Model}
\usage{
log_likelihood_generalized_2d(params, u1, u2, X_t, z1, z2, copula)
}
\arguments{
\item{params}{Numeric vector, model parameters including copula and GEV parameters.}

\item{u1}{Numeric vector (length \code{n_train}), pseudo-observations for margin 1.}

\item{u2}{Numeric vector (length \code{n_train}), pseudo-observations for margin 2.}

\item{X_t}{Numeric matrix (\verb{n_train x M}), risk factors affecting copula parameters.}

\item{z1}{Numeric matrix (\verb{n_train x M}), observed data for margin 1.}

\item{z2}{Numeric matrix (\verb{n_train x M}), observed data for margin 2.}

\item{copula}{Character, specifying the copula type: "Clayton", "Frank", "Gumbel", "Joe", or "Gaussian".}
}
\value{
The negative log-likelihood value for optimization.
}
\description{
Computes the negative log-likelihood of a 2-dimensional copula-GEV model,
incorporating dynamic Generalized Extreme Value (GEV) parameters and a
time-varying copula structure.
}
\examples{
test_ll_2d <-log_likelihood_generalized_2d(init_params_full,
                                  uu[,1],
                                  uu[,2],
                                  xx_train,
                                  zz_train[,1,],
                                  zz_train[,2,],
                                  "Gaussian")

}
